<?php
include 'db.php';

// Get all users ordered by referral count descending
$users = $conn->query("SELECT *, (SELECT COUNT(*) FROM users u2 WHERE u2.ref_by = u1.ref_code) as total_ref 
                       FROM users u1 ORDER BY total_ref DESC");

?>

<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Leaderboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
<style>
body { background:#f2f6fc; font-family:'Poppins', sans-serif; }
.leaderboard-card { border-radius:20px; background:#fff; padding:20px; margin-bottom:15px; box-shadow:0 5px 15px rgba(0,0,0,0.1);}
.avatar { font-size:50px; color:#0d6efd; }
.crown { font-size:24px; color:gold; margin-right:5px; }
.top-banner { background:linear-gradient(to right,#f6d365,#fda085); padding:15px; border-radius:10px; margin-bottom:20px; text-align:center; font-weight:bold; color:#fff; }
.search-box { margin-bottom:20px; }
</style>
</head>
<body>

<div class="container py-4">

<!-- Top Banner -->
<div class="top-banner">
১০০ সেল দিতে পারলে ৫০০০ টাকা | ২০০ সেল → ১০০০০ টাকা | ৫০০ সেল → ২০০০০ টাকা | ১০০০ সেল → ১০০০০০ টাকা
</div>

<!-- Search -->
<div class="search-box">
<input type="text" id="searchInput" class="form-control" placeholder="সার্চ ইউজার নাম দিয়ে...">
</div>

<!-- Leaderboard List -->
<div id="leaderboard">
<?php
$rank = 1;
while($user = $users->fetch_assoc()){
    echo '<div class="leaderboard-card d-flex align-items-center justify-content-between">';
    echo '<div class="d-flex align-items-center">';
    
    // Crown for top 3
    if($rank==1) echo '<i class="fas fa-crown crown"></i>';
    if($rank==2) echo '<i class="fas fa-crown crown" style="color:silver;"></i>';
    if($rank==3) echo '<i class="fas fa-crown crown" style="color:#cd7f32;"></i>';

    // Avatar Icon
    echo '<i class="fas fa-user-circle avatar me-3"></i>';

    echo '<div>';
    echo '<h6 class="mb-0">'.$user['fname'].' '.$user['lname'].'</h6>';
    echo '<small>Total Referrals: '.$user['total_ref'].'</small>';
    echo '</div>';
    echo '</div>';

    echo '<div><strong>Balance: ৳'.$user['balance'].'</strong></div>';
    echo '</div>';

    $rank++;
}
?>
</div>

</div>

<script>
document.getElementById('searchInput').addEventListener('keyup', function(){
    let filter = this.value.toLowerCase();
    let leaderboard = document.getElementById('leaderboard');
    let cards = leaderboard.getElementsByClassName('leaderboard-card');
    for(let i=0; i<cards.length; i++){
        let name = cards[i].querySelector('h6').textContent.toLowerCase();
        if(name.includes(filter)){
            cards[i].style.display = '';
        } else {
            cards[i].style.display = 'none';
        }
    }
});
</script>

</body>
</html>