<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8">
<!-- Browser Header / Tab Color -->
<meta name="theme-color" content="red">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Boytory Digital User Guideline</title>

<style>
body{
    margin:0;
    padding:0;
    font-family: "Poppins", sans-serif;
    background: #eef3ff;
    color:#222;
}

.container{
    width:90%;
    margin:auto;
    padding-bottom:70px;
    animation: fadeIn 1s ease;
}

@keyframes fadeIn{
    0%{opacity:0;transform:translateY(20px);}
    100%{opacity:1;transform:translateY(0);}
}

.header{
    text-align:center;
    padding:20px 0;
}
.header h1{
    font-size:28px;
    font-weight:700;
    color:#111;
    animation: glow 2s infinite;
}
@keyframes glow{
    0%{text-shadow:0 0 0px #bbb;}
    50%{text-shadow:0 0 10px #d7d7d7;}
    100%{text-shadow:0 0 0px #bbb;}
}

.card{
    background:#ffffffdd;
    padding:20px;
    border-radius:20px;
    margin-bottom:20px;
    backdrop-filter:blur(10px);
    border:1px solid rgba(0,0,0,0.08);
    box-shadow:0 0 20px rgba(0,0,0,0.05);
    transition:0.3s;
}
.card:hover{
    transform:translateY(-5px);
    box-shadow:0 0 25px rgba(0,0,0,0.12);
}

.card h2{
    font-size:22px;
    margin-bottom:10px;
    color:#222;
}

.icon{
    color:#0066ff;
    margin-right:8px;
}

.product-grid{
    display:grid;
    grid-template-columns:1fr 1fr;
    gap:15px;
    margin-top:20px;
}

.product-card{
    background:#ffffffcc;
    border-radius:18px;
    padding:12px;
    text-align:center;
    border:1px solid rgba(0,0,0,0.1);
    transition:0.3s;
}
.product-card:hover{
    transform:scale(1.04);
    box-shadow:0 0 20px rgba(0,0,0,0.15);
}
.product-card img{
    width:100%;
    height:120px;
    object-fit:cover;
    border-radius:12px;
    margin-bottom:10px;
}
.price{
    background:#ff0066;
    padding:5px 12px;
    display:inline-block;
    border-radius:12px;
    font-size:14px;
    margin-top:5px;
    color:white;
}

/* Extra Sections Styling */
.rule-item{
    background:#f8f9ff;
    padding:10px 15px;
    border-radius:10px;
    margin-bottom:10px;
    border-left:5px solid #4f46e5;
}
.policy-warning{
    background:#fff4e6;
    border-left:6px solid #ff7e00;
    padding:10px 15px;
    border-radius:12px;
}
</style>
</head>
<body>

<div class="container">

    <div class="header">
        <h1>📘 Buytory Digital সম্পূর্ণ ইউজার গাইডলাইন</h1>
    </div>

    <!-- ACCOUNT CREATE -->
    <div class="card">
        <h2><i class="icon">🧾</i>১. অ্যাকাউন্ট কিভাবে তৈরি করবেন?</h2>
        <ul>
            <li>✔ রেফার আইডি</li>
            <li>✔ ফার্স্ট নাম + লাস্ট নাম</li>
            <li>✔ ইমেইল</li>
            <li>✔ ফোন নম্বর</li>
            <li>✔ পাসওয়ার্ড</li>
        </ul>
    </div>

    <!-- LOGIN -->
    <div class="card">
        <h2><i class="icon">🔐</i>২. লগইন করবেন যেভাবে</h2>
        <p>ফোন নম্বর + পাসওয়ার্ড দিয়ে লগইন করুন।</p>
    </div>

    <!-- INACTIVE -->
    <div class="card">
        <h2><i class="icon">⚠️</i>৩. অ্যাকাউন্ট প্রথমে Inactive কেন?</h2>
        <p>নতুন ইউজার অ্যাকাউন্ট ডিফল্ট ভাবে Inactive থাকে।</p>
        <p>"Activate Account" এ ক্লিক করলে প্রোডাক্ট লিস্ট দেখাবে।</p>
    </div>

    <!-- PRODUCTS -->
    <div class="card">
        <h2><i class="icon">🛒</i>৪. অ্যাকাউন্ট Active করতে ১টি প্রোডাক্ট কিনুন</h2>
        <p>প্রতিটি প্রোডাক্টের দাম <b>৬০০ টাকা</b></p>

        <div class="product-grid">
            <div class="product-card">
                <img src="https://info.buytory.digital/Boy-Jacket.png">
                <h4>Boy Premium Jacket</h4>
                <div class="price">৳600</div>
            </div>

            <div class="product-card">
                <img src="https://info.buytory.digital/Lady-Jacet1.png">
                <h4>Lady Premium Jacket</h4>
                <div class="price">৳600</div>
            </div>

            <div class="product-card">
                <img src="https://info.buytory.digital/Ladyjacket.png">
                <h4>Lady Jacket</h4>
                <div class="price">৳600</div>
            </div>

            <div class="product-card">
                <img src="https://info.buytory.digital/sharee.png">
                <h4>Premium Sharee</h4>
                <div class="price">৳600</div>
            </div>

            <div class="product-card">
                <img src="https://info.buytory.digital/Shart.png">
                <h4>Premium Shart</h4>
                <div class="price">৳600</div>
            </div>

            <div class="product-card">
                <img src="Shart1.png">
                <h4>Premium Shart</h4>
                <div class="price">৳600</div>
            </div>

        </div>
    </div>

    <!-- MENU -->
    <div class="card">
        <h2><i class="icon">📂</i>৫. Dashboard Menu</h2>
        <ul>
            <li>✔ Sell করুন – কতটা সেল করেছেন</li>
            <li>✔ Withdraw – বিকাশ/নগদে তুলুন</li>
            <li>✔ Top List – শীর্ষ আয়কারীরা</li>
            <li>✔ Support – সকল যোগাযোগ মাধ্যম</li>
            <li>✔ Profile – আপনার তথ্য</li>
            <li>✔ Notice – গুরুত্বপূর্ণ ঘোষণা</li>
        </ul>
    </div>

    <!-- ADVANCED GUIDE -->
    <div class="card">
        <h2><i class="icon">💡</i>৬. Advance Guideline</h2>

        <div class="rule-item">✔ Withdraw করতে অ্যাকাউন্ট Active থাকা বাধ্যতামূলক।</div>
        <div class="rule-item">✔ ভুল তথ্য দিলে Withdraw ব্যর্থ হতে পারে।</div>
        <div class="rule-item">✔ প্রতিদিন নির্দিষ্ট সংখ্যক Withdraw Limit আছে।</div>
        <div class="rule-item">✔ প্রতারণা করলে অ্যাকাউন্ট Permanent Ban হবে।</div>
        <div class="rule-item">✔ Team income ও Sell income Dashboard-এ দেখা যাবে।</div>
        <div class="rule-item">✔ Activation payment সফল না হলে Account Active হবে না।</div>
        <div class="rule-item">✔ একই ডিভাইস থেকে একাধিক ভুয়া অ্যাকাউন্ট Opening নিষিদ্ধ।</div>
    </div>

    <!-- POLICY -->
    <div class="card">
        <h2><i class="icon">📜</i>৭. নীতি মালা (Policy)</h2>

        <div class="policy-warning">
            ⚠️ **Fraud Protection System সক্রিয়**  
            অস্বাভাবিক কার্যকলাপ দেখলে সিস্টেম স্বয়ংক্রিয়ভাবে অ্যাকাউন্ট Hold করবে।
        </div>

        <ul>
            <li>✔ আমরা কোন ধরনের Refund প্রদান করি না।</li>
            <li>✔ ভুল নম্বর দিলে Withdraw Lost হলে Platform দায়ী নয়।</li>
            <li>✔ একই ডিভাইস/IP থেকে ২টি একাউন্ট করা নিষিদ্ধ।</li>
            <li>✔ কোন অবৈধ প্রচারণা বা ভুল তথ্য দিলে ব্যান হবে।</li>
            <li>✔ Support এ যে কোন সময় যোগাযোগ করা যাবে।</li>
            <li>✔ সকল লেনদেন সম্পূর্ণ নিরাপদ ও এনক্রিপটেড।</li>
        </ul>
    </div>

</div>

</body>
</html>