<?php
include 'db.php'; // Database connection

if(!isset($_GET['id'])){
    die("User ID missing");
}

$id = intval($_GET['id']);

// Fetch user data
$sql = "SELECT * FROM users WHERE id=$id";
$result = $conn->query($sql);

if($result->num_rows == 0){
    die("User not found");
}

$user = $result->fetch_assoc();

// Handle form submission
if(isset($_POST['update'])){
    $fname = $conn->real_escape_string($_POST['fname']);
    $lname = $conn->real_escape_string($_POST['lname']);
    $email = $conn->real_escape_string($_POST['email']);
    $phone = $conn->real_escape_string($_POST['phone']);
    $balance = intval($_POST['balance']);
    $user_active = isset($_POST['user_active']) ? 1 : 0;

    $update_sql = "UPDATE users SET 
        fname='$fname', 
        lname='$lname', 
        email='$email', 
        phone='$phone', 
        balance='$balance', 
        user_active='$user_active'
        WHERE id=$id";

    if($conn->query($update_sql)){
        $success = "User updated successfully!";
        // Refresh user data
        $result = $conn->query($sql);
        $user = $result->fetch_assoc();
    } else {
        $error = "Update failed: " . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f2f6fc; font-family:'Poppins', sans-serif; }
.card { border-radius:20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
</style>
</head>
<body>

<div class="container py-5">

    <div class="text-center mb-4">
        <h2 class="fw-bold">Edit User</h2>
        <p class="text-muted">Update user information here</p>
    </div>

    <?php if(isset($success)): ?>
        <div class="alert alert-success text-center"><?= $success ?></div>
    <?php endif; ?>
    <?php if(isset($error)): ?>
        <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php endif; ?>

    <div class="card p-4 mx-auto" style="max-width:600px;">
        <form method="post">
            <div class="mb-3">
                <label class="form-label">First Name</label>
                <input type="text" name="fname" class="form-control" value="<?= htmlspecialchars($user['fname']) ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Last Name</label>
                <input type="text" name="lname" class="form-control" value="<?= htmlspecialchars($user['lname']) ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Phone</label>
                <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($user['phone']) ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Balance (Tk)</label>
                <input type="number" name="balance" class="form-control" value="<?= $user['balance'] ?>" required>
            </div>
            <div class="mb-3 form-check">
                <input type="checkbox" name="user_active" class="form-check-input" id="user_active" <?= $user['user_active'] == 1 ? 'checked' : '' ?>>
                <label class="form-check-label" for="user_active">Active</label>
            </div>
            <button type="submit" name="update" class="btn btn-primary w-100">Update User</button>
            <a href="user_list.php" class="btn btn-secondary w-100 mt-2">Back to User List</a>
        </form>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>